import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import classnames from 'classnames';

import {Spin} from '@components/Spin';

class PageOverlay extends Component {
    render() {
        const {loading, isShowMobileMenu} = this.props;

        return (
            <div
                className={classnames('passp-page-overlay', {
                    'passp-page-overlay_showed': loading || isShowMobileMenu,
                    'passp-page-overlay_mobile-menu': isShowMobileMenu
                })}
            >
                {loading && <Spin className='passp-page-overlay__loader' progress={true} size='l' />}
            </div>
        );
    }

    static mapStateToProps(state) {
        const {auth = {}, isLoading, mobileMenu = {}} = state;

        return {
            loading: auth.loading || isLoading,
            isShowMobileMenu: mobileMenu.isShowMobileMenu
        };
    }
}

PageOverlay.defaultProps = {
    loading: false,
    isShowMobileMenu: false
};

PageOverlay.propTypes = {
    loading: PropTypes.bool.isRequired,
    isShowMobileMenu: PropTypes.bool.isRequired
};

export default connect(PageOverlay.mapStateToProps)(PageOverlay);
