import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import AuthLetterPopup from '../AuthLetterPopup/AuthLetterPopup.jsx';
import PhoneConfirmationPopup from '../PhoneConfirmationPopup/PhoneConfirmationPopup.jsx';
import EmailConfirmationPopup from '../EmailConfirmationPopup/EmailConfirmationPopup.jsx';
import RestoreLoginEnterCaptchaPopup from '../RestoreLogin/EnterCaptchaPopup/EnterCaptchaPopup.jsx';
import AuthMessengerPopup from '../MessengerAuth/Popup/Popup.jsx';
import AuthMessengerInfoPopup from '../MessengerAuth/InfoPopup/InfoPopup.jsx';
import ChallengeCallPopup from '../Challenges/CallPopup/CallPopup.jsx';
/* eslint-disable max-len */
import AdditionalDataRequestPhoneConfirmationPopup from '../AdditionalDataRequestPhoneConfirmationPopup/AdditionalDataRequestPhoneConfirmationPopup.jsx';
import RestoreLoginEnterConfirmationCodePopup from '../RestoreLogin/EnterConfirmationCodePopup/EnterConfirmationCodePopup.jsx';
import {AuthConfirmationBySMSPopup} from '@blocks/authv2/components/AuthConfirmationBySMSPopup';
import {NeoPhonishAuthConfirmationBySMSPopup} from '@blocks/authv2/components/NeoPhonishAuthConfirmationBySMSPopup';
/* eslint-enable max-len */
import {Header} from '@blocks/authv2/components/Layout/Header/index';
import {CaptchaPopup} from '@blocks/authv2/components/CaptchaPopup';
import {PreviousStepButton} from '@blocks/authv2/components/PreviousStepButton';

const b = cn('PagePopup');

const PAGE_POPUP_TYPES = {
    authLetter: AuthLetterPopup,
    additionalDataRequestPhoneConfirmation: AdditionalDataRequestPhoneConfirmationPopup,
    captcha: CaptchaPopup,
    phoneConfirmation: PhoneConfirmationPopup,
    authConfirmationBySMS: AuthConfirmationBySMSPopup,
    emailConfirmation: EmailConfirmationPopup,
    restoreLoginEnterCaptcha: RestoreLoginEnterCaptchaPopup,
    restoreLoginEnterConfirmationCode: RestoreLoginEnterConfirmationCodePopup,
    authMessenger: AuthMessengerPopup,
    authMessengerInfo: AuthMessengerInfoPopup,
    challengeCall: ChallengeCallPopup,
    neoPhonishAuthConfirmationBySMS: NeoPhonishAuthConfirmationBySMSPopup
};

export class PagePopup extends Component {
    constructor(props) {
        super(props);

        this.isRuLogo = !props.language || ['ru', 'uk'].includes(props.language);
        this.logoName = `ys-${this.isRuLogo ? 'ru' : 'en'}-${this.isRuLogo ? '98' : '102'}x42`;
    }

    closePopup = () => {
        const {changePagePopupVisibility} = this.props;

        changePagePopupVisibility(false);
    };

    render() {
        const {pagePopupType} = this.props;
        const isCloseBtnShowed = !['authLetter', 'authMessenger'].includes(pagePopupType);
        const PagePopupChildComponent = PAGE_POPUP_TYPES[pagePopupType];

        return (
            <div className={b()}>
                {isCloseBtnShowed && <PreviousStepButton type='closer' onClick={this.closePopup} />}
                <Header />
                {PagePopupChildComponent && <PagePopupChildComponent closePopup={this.closePopup} />}
            </div>
        );
    }
}

PagePopup.propTypes = {
    pagePopupType: PropTypes.string,
    changePagePopupVisibility: PropTypes.func.isRequired,
    tld: PropTypes.string.isRequired,
    language: PropTypes.string.isRequired
};
