import {connect} from 'react-redux';
import {getLanguage} from '@blocks/selectors';
import {changePagePopupVisibility} from '@blocks/authv2/actions';
import {PagePopup} from './PagePopup.jsx';

const mapStateToProps = (state = {}) => {
    const {
        pagePopup: {isShowPagePopup, pagePopupType},
        settings: {tld}
    } = state;

    return {
        isShowPagePopup,
        pagePopupType,
        tld,
        language: getLanguage(state)
    };
};

const mapDispatchToProps = {
    changePagePopupVisibility
};

const ConnectedPagePopup = connect(mapStateToProps, mapDispatchToProps)(PagePopup);

export {ConnectedPagePopup as PagePopup};
