import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';

import showAccounts from '../../actions/showAccounts';

class PageVisibilityLayer extends Component {
    constructor(props) {
        super(props);

        this.addBrowserPageVisibilityStateHandler = this.addBrowserPageVisibilityStateHandler.bind(this);
        this.handleBrowserPageVisibilityState = this.handleBrowserPageVisibilityState.bind(this);
        this.removeBrowserPageVisibilityStateHandler = this.removeBrowserPageVisibilityStateHandler.bind(this);
    }

    componentDidMount() {
        this.addBrowserPageVisibilityStateHandler();
    }

    componentWillUnmount() {
        this.removeBrowserPageVisibilityStateHandler();
    }

    addBrowserPageVisibilityStateHandler() {
        if (document.addEventListener) {
            document.addEventListener('visibilitychange', this.handleBrowserPageVisibilityState, false);
        } else {
            document.attachEventListener('onvisibilitychange', this.handleBrowserPageVisibilityState, false);
        }
    }

    removeBrowserPageVisibilityStateHandler() {
        if (document.removeEventListener) {
            document.removeEventListener('visibilitychange', this.handleBrowserPageVisibilityState, false);
        } else {
            document.detachEvent('onvisibilitychange', this.handleBrowserPageVisibilityState, false);
        }
    }

    handleBrowserPageVisibilityState() {
        const {dispatch} = this.props;

        if (document.visibilityState === 'visible') {
            dispatch(showAccounts());
        }
    }

    render() {
        return <div className='passp-page-visibility' />;
    }
}

PageVisibilityLayer.propTypes = {
    dispatch: PropTypes.func.isRequired
};

export default connect()(PageVisibilityLayer);
