import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {CLICK_RESTORE_ACCESS_LINK, SHOW_PASSWORD_FORM, SHOW_SOCIAL_WITH_PASSWORD_FORM} from '../../metrics_constants';
import metrics from '../../../metrics';
import mapStateToProps from './mapStateToProps';
import switchToRestorePassword from '../../actions/switchToRestorePassword';
import {Password} from '@components/Password';

class PasswordField extends Component {
    fieldOptions = {
        autoCorrect: 'off',
        autoCapitalize: 'off',
        autoComplete: 'current-password'
    };

    updatedFieldLink = {};

    componentDidMount() {
        const {hasSocialButton} = this.props;

        metrics.send([hasSocialButton ? SHOW_SOCIAL_WITH_PASSWORD_FORM : SHOW_PASSWORD_FORM]);
        this.updatedFieldLink = this.defineFieldLinkHandler();
    }

    defineFieldLinkHandler = () => {
        const {hasSocialButton, fieldLink} = this.props;
        const updatedFieldLink = Object.assign({}, fieldLink);

        updatedFieldLink.onClick = () => {
            metrics.send([
                hasSocialButton ? SHOW_SOCIAL_WITH_PASSWORD_FORM : SHOW_PASSWORD_FORM,
                CLICK_RESTORE_ACCESS_LINK
            ]);

            this.props.dispatch(switchToRestorePassword());
        };

        return updatedFieldLink;
    };

    render() {
        const {password, onChange, fieldError, isShowFieldLink, inputLogin, login, hasRoundViewExp} = this.props;

        return (
            <>
                <input
                    className='g-hidden'
                    type='text'
                    name='login'
                    id='login'
                    readOnly={true}
                    autoComplete='username'
                    value={inputLogin || login}
                />

                <Password
                    hasToggler={true}
                    shouldValidate={false}
                    size='l'
                    label={hasRoundViewExp ? '' : i18n('_AUTH_.enter_password_title')}
                    value={password}
                    name='passwd'
                    error={fieldError}
                    options={this.fieldOptions}
                    link={this.updatedFieldLink}
                    isShowFieldLink={isShowFieldLink}
                    onChange={onChange}
                    placeholder={hasRoundViewExp ? i18n('_AUTH_.enter_password_title') : ''}
                    unvoicedPlaceholder={hasRoundViewExp ? '' : '* * * * * * * *'}
                    hasErrorIcon={Boolean(hasRoundViewExp && fieldError)}
                />
            </>
        );
    }
}

PasswordField.defaultProps = {
    fieldValue: ''
};

PasswordField.propTypes = {
    password: PropTypes.string,
    login: PropTypes.string,
    inputLogin: PropTypes.string,
    onChange: PropTypes.func.isRequired,
    fieldError: PropTypes.string,
    fieldLink: PropTypes.shape({
        url: PropTypes.string.isRequired,
        text: PropTypes.string.isRequired,
        onClick: PropTypes.func.isRequired
    }).isRequired,
    isShowFieldLink: PropTypes.bool.isRequired,
    hasSocialButton: PropTypes.bool,
    dispatch: PropTypes.func,
    hasRoundViewExp: PropTypes.bool
};

export default connect(mapStateToProps)(PasswordField);
