import errors from '../../errors';
import trimLastDot from '../../utils/trimLastDot';
import {CLICK_RESTORE_ACCESS_LINK, SHOW_PASSWORD_FORM, SHOW_SOCIAL_WITH_PASSWORD_FORM} from '../../metrics_constants';
import metrics from '../../../metrics';
import {hasExp} from '@blocks/selectors';

export default function mapStateToProps(state, ownProps) {
    const {
        auth: {
            passwordError,
            inputLogins,
            processedAccount,
            form: {login}
        },
        common: {restoration_url: restorationUrl, isWebView},
        am = {},
        customs: {hideForgetPasswordLink = false} = {}
    } = state;

    const {hasSocialButton} = ownProps;
    const restorationText =
        passwordError && ['captcha.required', 'password.empty', 'password.not_matched'].indexOf(passwordError) === -1
            ? i18n('_AUTH_.restore_access')
            : i18n('_AUTH_.remind_password');

    const fieldLink = {
        url: restorationUrl.replace('login=login', login ? `login=${login}` : ''),
        text: restorationText,
        pseudo: true,
        onClick: () => {
            metrics.send([
                hasSocialButton ? SHOW_SOCIAL_WITH_PASSWORD_FORM : SHOW_PASSWORD_FORM,
                CLICK_RESTORE_ACCESS_LINK
            ]);
        }
    };

    const fieldError = processPasswordError(passwordError);
    const isShowFieldLink =
        (!fieldError ||
            (fieldError !== errors.global &&
                [
                    'captcha.required',
                    'csrf_token.invalid',
                    'account.disabled',
                    'account.disabled_on_deletion',
                    'sessionid.overflow'
                ].indexOf(passwordError) === -1)) &&
        (am.isAm || !isWebView);
    const inputLogin = (processedAccount && inputLogins && inputLogins[processedAccount.uid]) || null;

    return {
        login,
        isShowFieldLink: !hideForgetPasswordLink && isShowFieldLink,
        fieldError,
        fieldLink,
        inputLogin,
        hasRoundViewExp: hasExp(state, 'rounded-input-exp')
    };
}

export function processPasswordError(passwordError) {
    if (!passwordError) {
        return '';
    }

    if (passwordError === 'captcha.required') {
        return '';
    }

    return trimLastDot(errors[passwordError] || errors.global);
}
