import {hasExp, isMobile} from '@blocks/selectors';

export default function mapStateToProps(state, ownProps) {
    const {
        common: {track_id: trackId, csrf, authUrl},
        auth: {
            form: {isForceOTP, password},
            passwordError,
            processedAccount: account,
            isQRAuthEnabled,
            loading
        },
        customs: {hideQrButton = false, hidePasswordAccountSuggest = false} = {}
    } = state;

    const allowedAuthMethods = (account && account.allowed_auth_methods) || [];

    let authMethod = (account && account.preferred_auth_method) || 'password';

    if (allowedAuthMethods.indexOf('otp') > -1 && isForceOTP) {
        authMethod = 'otp';
    }

    const hasCaptcha = Boolean(passwordError && passwordError.indexOf('captcha') > -1);
    const isShowPasswordField = Boolean(authMethod === 'password' || allowedAuthMethods.indexOf('password') > -1);
    const isShowOTPField = Boolean(authMethod === 'otp' || allowedAuthMethods.indexOf('otp') > -1);
    const isShowSubmitButton = Boolean(isShowPasswordField || isShowOTPField);
    const isMagicAuth =
        (!hasCaptcha && allowedAuthMethods.indexOf('magic') > -1) ||
        (allowedAuthMethods.indexOf('magic_x_token') > -1 && isQRAuthEnabled);
    const isShouldFallbackToPassword =
        !isShowPasswordField &&
        !isShowOTPField &&
        !ownProps.hasSocialButton &&
        !ownProps.isForceMailAuthEnable &&
        !allowedAuthMethods.includes('saml_sso') &&
        !allowedAuthMethods.includes('sms_code');
    const isShowQrButton = !hideQrButton && (!isMobile(state) || hasExp(state, 'newdesign-qr-enable'));

    return {
        password,
        trackId,
        csrf,
        passwordError,
        hidePasswordAccountSuggest,
        isShowPasswordField,
        isShowOTPField,
        authUrl,
        isShowSubmitButton,
        isShouldFallbackToPassword,
        isMagicAuth,
        hasCaptcha,
        loading,
        isShowQrButton
    };
}
