import {hasExp, isKeyEnabled2FASelector} from '@blocks/selectors';

export default function mapStateToProps(state = {}) {
    const {phoneConfirm = {}, am = {}, auth = {}} = state;

    return {
        ...phoneConfirm,
        isCaptchaRequired: phoneConfirm.isCaptchaRequired || auth.isCaptchaRequired,
        isKeyEnabled2FA: isKeyEnabled2FASelector(state),
        confirmationCodeFieldType: am.isAm ? 'number' : 'text',
        amPhoneNumber: (am.isAm && am.mode === 'phoneconfirm' && am.phone) || undefined,
        hasRoundViewExp: hasExp(state, 'rounded-input-exp')
    };
}
