export function showWithLeadZero(number) {
    return String(number).length < 2 ? `0${number}` : String(number);
}

export function getTimerSeconds(startTime, endTime, isUnixTimeStamp) {
    if (startTime > endTime) {
        return 0;
    }

    if (isUnixTimeStamp) {
        return Math.floor((endTime - startTime) % 60);
    }

    return Math.floor(((endTime - startTime) / 1000) % 60);
}

export function getTimerMinutes(startTime, endTime, isUnixTimeStamp) {
    if (startTime > endTime) {
        return 0;
    }

    if (isUnixTimeStamp) {
        return Math.floor((endTime - startTime) / 60);
    }

    return Math.floor((endTime - startTime) / 1000 / 60);
}
