import PropTypes from 'prop-types';
import React from 'react';
import {showWithLeadZero, getTimerSeconds, getTimerMinutes} from './PhoneConfirmationTimer.js';

export default function PhoneConfirmationTimer({startTime, endTime, isUnixTimeStamp}) {
    const timerMinutes = getTimerMinutes(startTime, endTime, isUnixTimeStamp);
    const timerSeconds = getTimerSeconds(startTime, endTime, isUnixTimeStamp);

    return (
        <span className='phone-confirmation-timer'>
            {showWithLeadZero(timerMinutes)}:{showWithLeadZero(timerSeconds)}
        </span>
    );
}

PhoneConfirmationTimer.propTypes = {
    startTime: PropTypes.number.isRequired,
    endTime: PropTypes.number.isRequired,
    isUnixTimeStamp: PropTypes.bool
};
