import trimLastDot from '@blocks/authv2/utils/trimLastDot';
import errors from '@blocks/authv2/errors';
import formatRegistrationUrl from '@blocks/authv2/utils/formatRegistrationUrl';
import {hasExp, isNeoPhonishRegisterAvailable} from '@blocks/selectors';

export default function mapStateToProps(state) {
    const {
        settings: {isNoTabletTouch},
        auth: {
            loginError,
            form: {login, phone, country},
            isRegisterWithSuggestToRestoreByPhoneInDaHouse
        },
        common: {registration_url_with_params: baseUrl},
        registerLite: {isLoginRequired: isAuthRegisterLiteLoginRequired}
    } = state;

    const hasCaptcha = Boolean(loginError && loginError.indexOf('captcha') > -1);

    return {
        isNoTabletTouch,
        hasCaptcha,
        registrationUrl: formatRegistrationUrl(baseUrl, login, phone, country),
        login,
        fieldError: processLoginError(loginError),
        isAuthRegisterLiteLoginRequired,
        isRegisterWithSuggestToRestoreByPhoneInDaHouse,
        isSwitchRegisterExp: hasExp(state, 'register-with-suggest-to-restore-by-phone-in-da-house-lite'),
        isNeoPhonishRegisterExp: isNeoPhonishRegisterAvailable(state)
    };
}

export function processLoginError(loginError) {
    if (!loginError) {
        return '';
    }

    if (loginError === 'captcha.required') {
        return '';
    }

    return trimLastDot(errors[loginError] || errors.global);
}
