import React, {Component} from 'react';
import {cn} from '@bem-react/classname';
import PropTypes from 'prop-types';
import {
    BACK_TO_SERVICE,
    SHOW_LOGIN_FORM,
    SHOW_SUGGEST_LIST,
    SHOW_PASSWORD_FORM
} from '@blocks/authv2/metrics_constants';
import metrics from '@blocks/metrics';
import {isUserEntryFlowProcessSecondaryStep} from '@blocks/UserEntryFlow/utils';
import {
    ENTRY_REGISTER_NEOPHONISH_PROCESS,
    ENTRY_REGISTER_PROCESS,
    ENTRY_REGISTER_PORTAL_PROCESS,
    ENTRY_REGISTER_NO_PHONE_PROCESS,
    ENTRY_RESTORE_NEOPHONISH_PROCESS,
    ENTRY_RESTORE_PROCESS,
    ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_PROCESS,
    ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_NEOPHONISH_PROCESS
} from '@blocks/UserEntryFlow/processes';

const b = cn('PreviousStepButton');

const WEBVIEW_ORIGINS_WITH_BUTTON = ['bnpl_checkout'];

export class PreviousStepButton extends Component {
    constructor(props) {
        super(props);

        this.handleBack = this.handleBack.bind(this);
    }

    isUserEntryFlowProcessSecondaryStep = () => {
        const {process, step} = this.props;

        return isUserEntryFlowProcessSecondaryStep(process, step);
    };

    handleBack(event) {
        event.preventDefault();

        const {link, backPane, historyPush, mode, onBack, onStepBack, type, onClick} = this.props;

        if (type === 'closer' && typeof onClick === 'function') {
            onClick();
            return;
        }

        if (this.isUserEntryFlowProcessSecondaryStep() && typeof onBack === 'function') {
            onBack();
            return;
        }

        if (typeof onStepBack === 'function') {
            onStepBack();
            return;
        }

        if (backPane) {
            historyPush(backPane, {isPreviousStep: true});
            return;
        }

        if (link) {
            const metricsHeader = {
                addingAccount: SHOW_LOGIN_FORM,
                edit: SHOW_SUGGEST_LIST,
                welcome: SHOW_PASSWORD_FORM
            };

            metrics.send([metricsHeader[mode], BACK_TO_SERVICE]);
            window.location = link;
        }
    }

    render() {
        const {
            backPane,
            link,
            isBackPaneVisible,
            isWebView,
            isFullScreen,
            type,
            isAM,
            isAm,
            origin,
            onStepBack
        } = this.props;

        if (isAM) {
            return null;
        }

        if (!isAm && isWebView && !WEBVIEW_ORIGINS_WITH_BUTTON.includes(origin) && !backPane && type !== 'closer') {
            return null;
        }

        if (!backPane && !link && !this.isUserEntryFlowProcessSecondaryStep() && type !== 'closer' && !onStepBack) {
            return null;
        }

        if (!isBackPaneVisible && type !== 'closer') {
            return null;
        }

        return (
            <a
                data-t={type === 'closer' ? 'closer' : 'backpane'}
                href={backPane || link || '#'}
                onClick={this.handleBack}
                className={b({type, isAm, isFullScreen})}
                aria-label={i18n('_AUTH_.prevBtn.aria_label')}
            >
                <span data-pane={backPane} data-link={link} />
            </a>
        );
    }
}

PreviousStepButton.propTypes = {
    backPane: PropTypes.string,
    link: PropTypes.string,
    mode: PropTypes.string,
    step: PropTypes.string,
    origin: PropTypes.string,
    historyPush: PropTypes.func.isRequired,
    onBack: PropTypes.func,
    onStepBack: PropTypes.func,
    isBackPaneVisible: PropTypes.bool,
    isWebView: PropTypes.bool,
    isFullScreen: PropTypes.bool,
    isAM: PropTypes.bool,
    isAm: PropTypes.bool,
    process: PropTypes.oneOf([
        ENTRY_RESTORE_PROCESS,
        ENTRY_REGISTER_PROCESS,
        ENTRY_REGISTER_PORTAL_PROCESS,
        ENTRY_REGISTER_NO_PHONE_PROCESS,
        ENTRY_REGISTER_NEOPHONISH_PROCESS,
        ENTRY_RESTORE_NEOPHONISH_PROCESS,
        ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_PROCESS,
        ENTRY_REGISTER_WITH_FULL_PERSONAL_INFO_NEOPHONISH_PROCESS
    ]),
    type: PropTypes.oneOf(['closer']),
    onClick: PropTypes.func
};
