import {connect} from 'react-redux';
import {push} from 'connected-react-router';
import {getProcessName} from '@blocks/UserEntryFlow/utils';
import {onBack} from '@blocks/UserEntryFlow/logic';
import {PreviousStepButton} from './PreviousStepButton.jsx';

const mapStateToProps = (state = {}) => {
    const {
        router = {},
        common: {pane, backPane, retpath, backpath, noreturn, isBackPaneVisible, isWebView, isAM, origin},
        auth: {mode} = {},
        customs: {noPrevStepButton = [], isFullScreen = false} = {},
        userEntryFlow = {},
        am = {}
    } = state;
    const {step} = userEntryFlow;
    const pathname = (router.location || {}).pathname;
    const process = getProcessName(state);
    const noBackPane = noPrevStepButton.includes(mode) || [pane, pathname].includes(backPane);

    return {
        backPane: noBackPane ? null : backPane,
        link: !noreturn && (backpath || retpath),
        isBackPaneVisible: typeof isBackPaneVisible === 'undefined' ? true : isBackPaneVisible,
        isWebView,
        isFullScreen,
        isAM,
        isAm: am.isAm,
        process,
        origin,
        mode,
        step
    };
};

const mapDispatchToProps = {
    onBack,
    historyPush: push
};

const ConnectedPreviousStepButton = connect(mapStateToProps, mapDispatchToProps)(PreviousStepButton);

export {ConnectedPreviousStepButton as PreviousStepButton};
