import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {Icon} from '@components/Icon';

export const QRButton = ({switchToModeMagic}) => (
    <Button view='pseudo' size='l' width='max' dataT='qr-button' onClick={switchToModeMagic}>
        <Icon type='qr' place='button' />
        {i18n('_AUTH_.QRButton.enter')}
    </Button>
);

QRButton.propTypes = {
    switchToModeMagic: PropTypes.func.isRequired
};
