import React from 'react';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {SHOW_LOGIN_FORM, CLICK_REGISTRATION_LINK_FROM_ERROR} from '@blocks/authv2/metrics_constants';
import metrics from '@blocks/metrics';

class RegisterButton extends React.PureComponent {
    sendMetrics = () => {
        metrics.send([SHOW_LOGIN_FORM, CLICK_REGISTRATION_LINK_FROM_ERROR]);
    };

    onClick = (event) => {
        const {
            isRegisterWithSuggestToRestoreByPhoneInDaHouse,
            switchToModeRegisterLite,
            switchToModeRegister,
            isNeoPhonishRegisterExp,
            registrationType
        } = this.props;
        const isLiteRegButton = registrationType !== 'portal';

        this.sendMetrics();

        if (isRegisterWithSuggestToRestoreByPhoneInDaHouse || isNeoPhonishRegisterExp) {
            event.preventDefault();
            switchToModeRegister();
        }

        if (isLiteRegButton) {
            event.preventDefault();
            switchToModeRegisterLite();
        }
    };

    render() {
        const {url, hideRegButton} = this.props;

        if (hideRegButton) {
            return null;
        }

        return (
            <div className='passp-button passp-register-button'>
                <Button
                    type='link'
                    url={url}
                    onClick={this.onClick}
                    text={i18n('_AUTH_.register_id')}
                    view='pseudo'
                    width='max'
                    size='l'
                />
            </div>
        );
    }
}

RegisterButton.propTypes = {
    login: PropTypes.string,
    url: PropTypes.string.isRequired,
    switchToModeRegisterLite: PropTypes.func.isRequired,
    switchToModeRegister: PropTypes.func,
    registrationType: PropTypes.string.isRequired,
    hideRegButton: PropTypes.bool,
    isPreRegisterExp: PropTypes.bool,
    isRegisterWithSuggestToRestoreByPhoneInDaHouse: PropTypes.bool,
    isNeoPhonishRegisterExp: PropTypes.bool
};

export default RegisterButton;
