import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import {Field} from '@components/Field';
import {Button} from '@components/Button';
import {setupBackPane} from '../../../actions/index.js';
import DomikForm from '@blocks/authv2/components/Form/Form.jsx';

class Form extends Component {
    ref = React.createRef();

    focus = () => {
        if (this.ref.current && this.ref.current.focus) {
            this.ref.current.focus();
        }
    };

    componentDidMount() {
        const {dispatch, authLiteRegisterUrl} = this.props;

        dispatch(setupBackPane(authLiteRegisterUrl));

        setTimeout(this.focus, 300);
    }

    render() {
        const {
            firstname,
            lastname,
            firstnameError,
            lastnameError,
            trackId,
            handleNameField,
            handleLastNameField,
            submitForm
        } = this.props;

        return (
            <DomikForm onSubmit={submitForm} method='post' dataT='enter-name'>
                <div className='passp-register-lite_form'>
                    <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                    <div className='passp-password-field passp-register-lite_password'>
                        <Field
                            size='l'
                            ref={this.ref}
                            name='firstname'
                            type='text'
                            label={i18n('_AUTH_.field_firstname')}
                            value={firstname}
                            error={firstnameError}
                            onChange={handleNameField}
                            view='big-input'
                        />
                        <Field
                            size='l'
                            name='lastname'
                            type='text'
                            label={i18n('_AUTH_.field_lastname')}
                            value={lastname}
                            error={lastnameError}
                            onChange={handleLastNameField}
                            view='big-input'
                        />
                        <div className='passp-button passp-lite__password-submit'>
                            <Button
                                onClick={submitForm}
                                type='submit'
                                text={i18n('_AUTH_.next')}
                                view='action'
                                size='l'
                                width='max'
                            />
                        </div>
                    </div>
                </div>
            </DomikForm>
        );
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(Form);

Form.propTypes = {
    firstname: PropTypes.string,
    lastname: PropTypes.string,
    firstnameError: PropTypes.string,
    lastnameError: PropTypes.string,
    trackId: PropTypes.string,
    handleNameField: PropTypes.func.isRequired,
    handleLastNameField: PropTypes.func.isRequired,
    submitForm: PropTypes.func.isRequired,
    dispatch: PropTypes.func.isRequired,
    authLiteRegisterUrl: PropTypes.string
};
