import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {connect} from 'react-redux';
import mapDispatchToProps from './mapDispatchToProps';
import mapStatesToProps from './mapStateToProps';
import {Button} from '@components/Button';
import metrics from '../../../../metrics';
import {REGISTER_LITE_EULA_SUBMIT} from '../../../metrics_constants';
import DomikForm from '@blocks/authv2/components/Form/Form.jsx';
import {ServiceSubscriptionPermission} from '@components/ServiceSubscripionPermission';

class Eula extends PureComponent {
    constructor(props) {
        super(props);

        this.submitForm = this.submitForm.bind(this);
    }

    componentDidMount() {
        this.buttonRef && this.buttonRef.focus();
    }

    submitForm(event) {
        event.preventDefault();
        metrics.send([REGISTER_LITE_EULA_SUBMIT]);
        this.props.registerLiteAccount();
    }

    render() {
        const {keepUnsubscribedExp, eulaTexts = {}} = this.props;
        const {description: eulaDescription} = eulaTexts;

        return (
            <DomikForm onSubmit={this.submitForm} method='post' dataT='register-lite-eula'>
                <p
                    className={classnames('passp-register-lite_eula', {leftAligned: keepUnsubscribedExp})}
                    dangerouslySetInnerHTML={{__html: eulaDescription}}
                />
                <ServiceSubscriptionPermission />
                <div className='passp-button passp-lite__password-submit'>
                    <Button
                        controlRef={(ref) => (this.buttonRef = ref)}
                        onClick={this.submitForm}
                        type='submit'
                        text={i18n('_AUTH_.registration_submit')}
                        view='action'
                        size='l'
                        width='max'
                    />
                </div>
            </DomikForm>
        );
    }
}

export default connect(mapStatesToProps, mapDispatchToProps)(Eula);

Eula.propTypes = {
    registerLiteAccount: PropTypes.func.isRequired,
    keepUnsubscribedExp: PropTypes.bool,
    eulaTexts: PropTypes.shape({
        title: PropTypes.string,
        description: PropTypes.string,
        button: PropTypes.string
    }).isRequired
};
