import React, {Component, Fragment} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import AccountListItem from '../AccountListItem/AccountListItem.jsx';
import Form from '../../Form/Form.jsx';

import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import metrics from '../../../../metrics';
import {
    RESTORE_LOGIN_SEARCH_ANOTHER_NAME,
    RESTORE_LOGIN_SEARCH_ANOTHER_NAME_FOR_EMPTY_LIST,
    RESTORE_LOGIN_SEARCH_ANOTHER_PHONE,
    RESTORE_LOGIN_SEARCH_ANOTHER_PHONE_FOR_EMPTY_LIST,
    RESTORE_LOGIN_CHOOSE_ANOTHER_ACCOUNT,
    RESTORE_LOGIN_CHOOSE_ANOTHER_ACCOUNT_FOR_EMPTY_LIST,
    RESTORE_LOGIN_SHOW_ACCOUNTS_LIST_PAGE,
    RESTORE_LOGIN_SHOW_EMPTY_ACCOUNTS_LIST_PAGE,
    RESTORE_LOGIN_PAGE,
    RESTORE_LOGIN_SEARCH_ANOTHER
} from '../../../metrics_constants';

class AccountList extends Component {
    constructor(props) {
        super(props);

        this.retryWithAnotherPhone = this.retryWithAnotherPhone.bind(this);
        this.retryWithAnotherName = this.retryWithAnotherName.bind(this);
        this.signInWithAnotherAccount = this.signInWithAnotherAccount.bind(this);
    }

    componentDidMount() {
        metrics.send([
            RESTORE_LOGIN_PAGE,
            this.props.hasAccounts ? RESTORE_LOGIN_SHOW_ACCOUNTS_LIST_PAGE : RESTORE_LOGIN_SHOW_EMPTY_ACCOUNTS_LIST_PAGE
        ]);
    }

    retryWithAnotherPhone(event) {
        const {switchToModeRestoreLogin, hasAccounts} = this.props;

        switchToModeRestoreLogin(event);
        metrics.send([
            RESTORE_LOGIN_PAGE,
            hasAccounts ? RESTORE_LOGIN_SEARCH_ANOTHER_PHONE : RESTORE_LOGIN_SEARCH_ANOTHER_PHONE_FOR_EMPTY_LIST
        ]);
    }

    retry = (event) => {
        const {switchToModeRestoreLogin} = this.props;

        switchToModeRestoreLogin(event);
        metrics.send([RESTORE_LOGIN_PAGE, RESTORE_LOGIN_SEARCH_ANOTHER]);
    };

    retryWithAnotherName() {
        const {openEnterNameForm, hasAccounts} = this.props;

        openEnterNameForm();
        metrics.send([
            RESTORE_LOGIN_PAGE,
            hasAccounts ? RESTORE_LOGIN_SEARCH_ANOTHER_NAME : RESTORE_LOGIN_SEARCH_ANOTHER_NAME_FOR_EMPTY_LIST
        ]);
    }

    signInWithAnotherAccount(event) {
        const {switchToModeAddingAccount, hasAccounts} = this.props;

        switchToModeAddingAccount(event);
        metrics.send([
            RESTORE_LOGIN_PAGE,
            hasAccounts ? RESTORE_LOGIN_CHOOSE_ANOTHER_ACCOUNT : RESTORE_LOGIN_CHOOSE_ANOTHER_ACCOUNT_FOR_EMPTY_LIST
        ]);
    }

    render() {
        const {
            accounts,
            addUserUrl,
            restoreLoginUrl,
            hasAccounts,
            avatarPath,
            addUserWithLoginUrl,
            startAuth,
            isNotFoundPhoneError
        } = this.props;

        return (
            <div className='passp-account-list'>
                {hasAccounts ? (
                    <Fragment>
                        <ul className='passp-account-list-items'>
                            {accounts.map((account) => (
                                <li className='passp-account-list-item_block' key={account.uid}>
                                    <AccountListItem
                                        account={account}
                                        avatarPath={avatarPath}
                                        addUserWithLoginUrl={addUserWithLoginUrl}
                                        startAuth={startAuth}
                                    />
                                </li>
                            ))}
                        </ul>

                        <Form cls='another-login' dataT='another-login'>
                            <div data-t='retry_with_another_data' className='passp-button passp-button_long-text'>
                                <Button
                                    type='link'
                                    text={i18n('Profile.common.one-more-time')}
                                    url={restoreLoginUrl}
                                    onClick={this.retry}
                                    view='action'
                                    size='l'
                                    width='max'
                                />
                            </div>

                            <div data-t='signin_with_another_account' className='passp-button'>
                                <Button
                                    type='link'
                                    text={i18n('_AUTH_.RestoreLogin.signin_with_another_account')}
                                    url={addUserUrl}
                                    onClick={this.signInWithAnotherAccount}
                                    view='pseudo'
                                    size='l'
                                    width='max'
                                />
                            </div>
                        </Form>
                    </Fragment>
                ) : (
                    <Form cls='retry-search-login'>
                        <div data-t='retry_with_another_phone' className='passp-button passp-button_long-text'>
                            <Button
                                type='link'
                                text={i18n('OneDomik.RestoreLogin.retry_with_another_phone')}
                                url={restoreLoginUrl}
                                onClick={this.retryWithAnotherPhone}
                                view='action'
                                size='l'
                                width='max'
                            />
                        </div>

                        <div data-t='retry_with_another_name' className='passp-button passp-button_long-text'>
                            {!isNotFoundPhoneError && (
                                <Button
                                    type='button'
                                    text={i18n('OneDomik.RestoreLogin.retry_with_another_name')}
                                    onClick={this.retryWithAnotherName}
                                    view='action'
                                    size='l'
                                    width='max'
                                />
                            )}
                        </div>

                        <div data-t='signin_with_another_account' className='passp-button'>
                            <Button
                                type='link'
                                text={i18n('_AUTH_.RestoreLogin.signin_with_another_account')}
                                url={addUserUrl}
                                onClick={this.signInWithAnotherAccount}
                                view='pseudo'
                                size='l'
                                width='max'
                            />
                        </div>
                    </Form>
                )}
            </div>
        );
    }
}

AccountList.propTypes = {
    accounts: PropTypes.array.isRequired,
    hasAccounts: PropTypes.bool.isRequired,
    isNotFoundPhoneError: PropTypes.bool.isRequired,
    avatarPath: PropTypes.string.isRequired,
    restoreLoginUrl: PropTypes.string.isRequired,
    addUserUrl: PropTypes.string.isRequired,
    addUserWithLoginUrl: PropTypes.string.isRequired,
    startAuth: PropTypes.func.isRequired,
    switchToModeAddingAccount: PropTypes.func.isRequired,
    switchToModeRestoreLogin: PropTypes.func.isRequired,
    openEnterNameForm: PropTypes.func.isRequired
};

export default connect(mapStateToProps, mapDispatchToProps)(AccountList);
