import multiStepAuthStart from '../../../actions/multiStepAuthStart';
import switchToModeRestoreLoginProcess from '../../../actions/switchToModeRestoreLoginProcess';
import switchToModeAddingAccount from '../../../actions/switchToModeAddingAccount';
import switchToModeRestoreLogin from '../../../actions/switchToModeRestoreLogin';
import {clearErrors} from '../../../actions/restoreLogin';
import {updateTrack} from '../../../../common/actions';

export default function mapDispatchToProps(dispatch) {
    return {
        startAuth: (login, backPath) => dispatch(multiStepAuthStart({login, backPane: backPath})),
        openEnterNameForm: () => {
            dispatch(clearErrors());
            dispatch(switchToModeRestoreLoginProcess());
        },
        switchToModeAddingAccount: (event) => {
            event.preventDefault();
            dispatch(clearErrors());
            dispatch(switchToModeAddingAccount());
        },
        switchToModeRestoreLogin: (event) => {
            event.preventDefault();
            dispatch(clearErrors());
            dispatch(updateTrack(null));
            dispatch(switchToModeRestoreLogin());
        }
    };
}
