export default function mapStateToProps(state) {
    const {
        restoreLogin: {
            accounts,
            errors: {phone: phoneError}
        },
        settings: {avatar},
        common: {restoreLoginUrl, addUserWithLoginUrl, addUserUrl}
    } = state;
    const avatarPath = `https://${avatar.host}${avatar.pathname}`;
    const hasAccounts = (accounts || []).length > 0;
    const isNotFoundPhoneError = Boolean(phoneError && phoneError === 'notFound');

    return {
        accounts,
        hasAccounts,
        avatarPath,
        restoreLoginUrl,
        addUserWithLoginUrl,
        addUserUrl,
        isNotFoundPhoneError
    };
}
