import React, {Component} from 'react';
import PropTypes from 'prop-types';

import {Link} from '@components/Link';
import metrics from '../../../../metrics';
import {RESTORE_LOGIN_ACCOUNT_SELECT, RESTORE_LOGIN_PAGE} from '../../../metrics_constants';

class AccountListItem extends Component {
    constructor(props) {
        super(props);

        this.openPasswordForm = this.openPasswordForm.bind(this);
    }

    openPasswordForm(event) {
        event.preventDefault();

        const {startAuth, account} = this.props;

        startAuth(account.login);
        metrics.send([RESTORE_LOGIN_PAGE, RESTORE_LOGIN_ACCOUNT_SELECT]);
    }

    render() {
        const {account, avatarPath, addUserWithLoginUrl} = this.props;

        const avatarStyle = {
            backgroundImage: `url("${avatarPath
                .replace('%uid%', account.default_avatar)
                .replace('%size%', '200')
                .replace('%login%', account.login)}")`
        };

        return (
            <div className='passp-account-list-item-block'>
                <Link
                    className='passp-account-list-item passp-account-list-item__without-login'
                    href={addUserWithLoginUrl.replace('login=login', `login=${account.login}`)}
                    onClick={this.openPasswordForm}
                >
                    <div className='passp-account-list-item__inner'>
                        <span className='passp-account-list-item__avatar' style={avatarStyle} />
                        <span className='passp-account-list-item__display-name'>{account.login}</span>
                    </div>
                </Link>
            </div>
        );
    }
}

AccountListItem.propTypes = {
    account: PropTypes.object,
    avatarPath: PropTypes.string.isRequired,
    addUserWithLoginUrl: PropTypes.string.isRequired,
    startAuth: PropTypes.func.isRequired
};

export default AccountListItem;
