import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import CaptchaField from '../../CaptchaField/CaptchaField.jsx';
import Title from '../../Title/Title.jsx';
import Form from '../../Form/Form.jsx';
import PagePopupContent from '../../PagePopupContent/PagePopupContent.jsx';

import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import metrics from '../../../../metrics';
import {RESTORE_LOGIN_PAGE, RESTORE_LOGIN_SHOW_ENTER_CAPTCHA_PAGE} from '../../../metrics_constants';

const errorMessages = {
    internal: i18n('_AUTH_.Errors.internal'),
    phone: {
        undefined: i18n('_AUTH_.errors.required'),
        empty: i18n('_AUTH_.errors.required'),
        invalid: i18n('_AUTH_.phones.errors.phone.invalid'),
        callsLimitExceeded: i18n('_AUTH_.phone-calls-limit-exceeded'),
        smsLimitExceeded: i18n('_AUTH_.phones.errors.limit-exceeded'),
        rateLimitExceeded: i18n('_AUTH_.phone-confirm_errors_confirmations_limitexceeded_one_number')
    }
};

class EnterCaptchaPopup extends Component {
    constructor(props) {
        super(props);

        this.submitForm = this.submitForm.bind(this);
    }

    componentDidMount() {
        metrics.send([RESTORE_LOGIN_PAGE, RESTORE_LOGIN_SHOW_ENTER_CAPTCHA_PAGE]);
    }

    submitForm(event) {
        event.preventDefault();
        this.props.checkPhone();
    }

    render() {
        const {phoneError} = this.props;

        const phoneFieldError = (phoneError && (errorMessages.phone[phoneError] || errorMessages.internal)) || '';

        return (
            <PagePopupContent cls='restore-login-enter-captcha' dataT='enter-captcha'>
                <Title>{i18n('_AUTH_.RestoreLogin.enter-captcha.title')}</Title>

                <Form onSubmit={this.submitForm} cls='enter-captcha' dataT='enter-captcha'>
                    <CaptchaField isShowCaptcha={true} forcedError={phoneFieldError} />

                    <div data-t='submit-captcha-btn' className='passp-button'>
                        <Button
                            text={i18n('_AUTH_.RestoreLogin.next-step')}
                            type='submit'
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                </Form>
            </PagePopupContent>
        );
    }
}

EnterCaptchaPopup.propTypes = {
    checkPhone: PropTypes.func.isRequired,
    phoneError: PropTypes.string.isRequired
};

export default connect(mapStateToProps, mapDispatchToProps)(EnterCaptchaPopup);
