export default function mapStateToProps(state) {
    const {
        restoreLogin: {
            phone,
            isPhoneCheckSent,
            isPhoneOverheated,
            callingNumberTemplate,
            errors: {code: codeError, phone: phoneError},
            confirmMethod
        }
    } = state;
    const formattedPhone = (phone || '').trim().replace(/ /gi, '&nbsp;');

    let title = i18n('_AUTH_.RestoreLogin.enter-confirmation-code.title').replace('%1', formattedPhone);

    let confirmationCodeLength = 6;

    let sendAgainBtnText = i18n('_AUTH_.enter-confirmation-code.send-again.v2');

    let canSwitchConfirmMethod = false;
    const isCallsLimitExceededError = codeError === 'callsLimitExceeded' || phoneError === 'callsLimitExceeded';

    if (confirmMethod !== 'by_sms') {
        sendAgainBtnText = i18n('_AUTH_.RestoreLogin.recall');
        canSwitchConfirmMethod = true;
    }

    if (confirmMethod === 'by_call') {
        title = i18n('_AUTH_.RestoreLogin.call_confirm_title');
    }

    if (confirmMethod === 'by_flash_call') {
        title = i18n('_AUTH_.RestoreLogin.discard_call_confirm_title').replace(
            '%s',
            `<span class='passp-phone-template'>${callingNumberTemplate}</span>`
        );
        confirmationCodeLength = 4;
    }

    const isCallConfirmationDisabled = (isPhoneOverheated || isCallsLimitExceededError) && canSwitchConfirmMethod;

    return {
        codeError: codeError || '',
        confirmMethod,
        isCallConfirmationDisabled,
        title,
        isPhoneCheckSent,
        confirmationCodeLength,
        sendAgainBtnText,
        canSwitchConfirmMethod
    };
}
