import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';

import {Field} from '@components/Field';
import Form from '../../Form/Form.jsx';
import {Button} from '@components/Button';

import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';

const errorMessages = {
    internal: i18n('_AUTH_.Errors.internal'),
    firstName: {
        undefined: i18n('_AUTH_.errors.required'),
        empty: i18n('_AUTH_.errors.required'),
        rateLimitExceeded: i18n('_AUTH_.question.attempts_limit_exceeded')
    },
    lastName: {
        undefined: i18n('_AUTH_.errors.required'),
        empty: i18n('_AUTH_.errors.required'),
        rateLimitExceeded: i18n('_AUTH_.question.attempts_limit_exceeded')
    }
};

class EnterNameForm extends Component {
    constructor(props) {
        super(props);

        this.submitForm = this.submitForm.bind(this);
    }

    componentDidMount() {
        const {
            changeFirstName,
            changeLastName,
            changeNativeInputValue,
            setupBackPane,
            setupPane,
            restoreLoginProcessUrl
        } = this.props;

        changeFirstName('');
        changeLastName('');
        changeNativeInputValue('firstname', '');
        changeNativeInputValue('lastname', '');
        setupBackPane(null);
        setupPane(restoreLoginProcessUrl);
    }

    submitForm(event) {
        event.preventDefault();
        this.props.checkNames();
    }

    render() {
        const {
            firstName,
            lastName,
            changeFirstName,
            changeLastName,
            firstNameError,
            lastNameError,
            trackId
        } = this.props;
        const firstNameFieldError =
            (firstNameError && (errorMessages.firstName[firstNameError] || errorMessages.internal)) || '';
        const lastNameFieldError =
            (lastNameError && (errorMessages.lastName[lastNameError] || errorMessages.internal)) || '';

        return (
            <Form onSubmit={this.submitForm} cls='enter-name' dataT='enter-name'>
                <input data-t='track_id' type='hidden' value={trackId} />

                <Field
                    size='l'
                    name='firstname'
                    type='text'
                    className='passp-firstname-field'
                    label={i18n('OneDomik.RestoreLogin.enter-name.label')}
                    value={firstName}
                    error={firstNameFieldError}
                    onChange={changeFirstName}
                    view='big-input'
                />

                <Field
                    size='l'
                    name='lastname'
                    type='text'
                    className='passp-lastname-field'
                    label={i18n('OneDomik.RestoreLogin.enter-surname.label')}
                    value={lastName}
                    error={lastNameFieldError}
                    onChange={changeLastName}
                    view='big-input'
                />

                <div className='passp-button'>
                    <Button
                        type='submit'
                        text={i18n('_AUTH_.RestoreLogin.next-step')}
                        view='action'
                        size='l'
                        width='max'
                    />
                </div>
            </Form>
        );
    }
}

EnterNameForm.propTypes = {
    firstName: PropTypes.string.isRequired,
    lastName: PropTypes.string.isRequired,
    firstNameError: PropTypes.string.isRequired,
    trackId: PropTypes.string.isRequired,
    lastNameError: PropTypes.string.isRequired,
    restoreLoginProcessUrl: PropTypes.string.isRequired,
    changeFirstName: PropTypes.func.isRequired,
    changeNativeInputValue: PropTypes.func.isRequired,
    changeLastName: PropTypes.func.isRequired,
    setupBackPane: PropTypes.func.isRequired,
    setupPane: PropTypes.func.isRequired,
    checkNames: PropTypes.func.isRequired
};

export default connect(mapStateToProps, mapDispatchToProps)(EnterNameForm);
