import React, {Component} from 'react';
import {connect} from 'react-redux';
import PropTypes from 'prop-types';
import {Button} from '@components/Button';
import {Field} from '@components/Field';
import Form from '../../Form/Form.jsx';

import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import metrics from '../../../../metrics';
import {RESTORE_LOGIN_ENTER_CAPTCHA_SUCCESS, RESTORE_LOGIN_PAGE} from '../../../metrics_constants';

class EnterPhoneForm extends Component {
    constructor(props) {
        super(props);

        this.submitForm = this.submitForm.bind(this);
    }

    componentDidMount() {
        const {
            changeCaptchaState,
            changeNativeInputValue,
            changePhone,
            setupBackPane,
            setupPane,
            hasUnitedAccounts,
            addUserUrl,
            restoreLoginUrl,
            editUrl
        } = this.props;

        changeCaptchaState(true);
        changePhone('');
        changeNativeInputValue('phone', '');
        setupBackPane(hasUnitedAccounts ? editUrl : addUserUrl);
        setupPane(restoreLoginUrl);
    }

    componentDidUpdate(prevProps) {
        const isCaptchaSentSuccessfully =
            prevProps.isCaptchaRequired && !this.props.isCaptchaRequired && this.props.isPhoneCheckSent;

        if (isCaptchaSentSuccessfully) {
            metrics.send([RESTORE_LOGIN_PAGE, RESTORE_LOGIN_ENTER_CAPTCHA_SUCCESS]);
        }
    }

    componentWillUnmount() {
        this.props.changeCaptchaState(false);
    }

    submitForm(event) {
        event.preventDefault();

        this.props.checkPhone();
    }

    render() {
        const {phone, changePhone, fieldError, trackId} = this.props;

        return (
            <Form onSubmit={this.submitForm} cls='enter-phone' dataT='enter-phone'>
                <input data-t='track_id' type='hidden' value={trackId} />

                <Field
                    size='l'
                    name='phone'
                    type='text'
                    label={i18n('OneDomik.RestoreLogin.enter-phone.label')}
                    value={phone}
                    error={fieldError}
                    onChange={changePhone}
                    view='big-input'
                />

                <div className='passp-button'>
                    <Button
                        type='submit'
                        text={i18n('_AUTH_.RestoreLogin.next-step')}
                        view='action'
                        size='l'
                        width='max'
                    />
                </div>
            </Form>
        );
    }
}

EnterPhoneForm.propTypes = {
    phone: PropTypes.string.isRequired,
    fieldError: PropTypes.string,
    trackId: PropTypes.string.isRequired,
    addUserUrl: PropTypes.string.isRequired,
    editUrl: PropTypes.string.isRequired,
    restoreLoginUrl: PropTypes.string.isRequired,
    changePhone: PropTypes.func.isRequired,
    checkPhone: PropTypes.func.isRequired,
    changeCaptchaState: PropTypes.func.isRequired,
    changeNativeInputValue: PropTypes.func.isRequired,
    setupBackPane: PropTypes.func.isRequired,
    setupPane: PropTypes.func.isRequired,
    getTrack: PropTypes.func,
    hasUnitedAccounts: PropTypes.bool,
    isCaptchaRequired: PropTypes.bool,
    isPhoneCheckSent: PropTypes.bool
};

export default connect(mapStateToProps, mapDispatchToProps)(EnterPhoneForm);
