const errorMessages = {
    internal: i18n('_AUTH_.Errors.internal'),
    undefined: i18n('_AUTH_.errors.required'),
    empty: i18n('_AUTH_.errors.required'),
    invalid: i18n('_AUTH_.phones.errors.phone.invalid'),
    callsLimitExceeded: i18n('_AUTH_.phone-calls-limit-exceeded'),
    smsLimitExceeded: i18n('_AUTH_.phones.errors.limit-exceeded'),
    rateLimitExceeded: i18n('_AUTH_.phone-confirm_errors_confirmations_limitexceeded_one_number')
};

export default function mapStateToProps(state) {
    const {
        restoreLogin: {
            phone,
            errors: {phone: phoneError},
            isPhoneCheckSent
        },
        auth: {isCaptchaRequired, unitedAccounts},
        common: {addUserUrl, restoreLoginUrl, editUrl, track_id: trackId}
    } = state;
    const hasUnitedAccounts = Object.keys(unitedAccounts).length > 0;
    const fieldError =
        (phoneError &&
            !['notFound', 'callsLimitExceeded'].includes(phoneError) &&
            (errorMessages[phoneError] || errorMessages.internal)) ||
        '';

    return {
        phone: phone || '',
        trackId: trackId || '',
        fieldError,
        addUserUrl,
        restoreLoginUrl,
        editUrl,
        hasUnitedAccounts,
        isPhoneCheckSent,
        isCaptchaRequired
    };
}
