import React, {Component} from 'react';
import PropTypes from 'prop-types';

export default class Timer extends Component {
    constructor(props) {
        super(props);

        this.startTimer = this.startTimer.bind(this);
        this.stopTimer = this.stopTimer.bind(this);

        this.timerInterval = null;
        this.state = {currentCountdown: 30};
    }

    componentDidMount() {
        this.startTimer();
    }

    componentWillUnmount() {
        this.stopTimer();
    }

    startTimer() {
        const {onTimerEnd} = this.props;

        this.setState({currentCountdown: 30});

        this.timerInterval = setInterval(() => {
            this.setState((prev) => ({currentCountdown: prev.currentCountdown - 1}));

            if (this.state.currentCountdown <= 1) {
                this.stopTimer();

                if (onTimerEnd && typeof onTimerEnd === 'function') {
                    onTimerEnd();
                }
            }
        }, 1000);
    }

    stopTimer() {
        if (this.timerInterval) {
            clearInterval(this.timerInterval);
            this.timerInterval = null;
        }

        this.setState({currentCountdown: 0});
    }

    render() {
        const {currentCountdown} = this.state;

        if (currentCountdown <= 1) {
            return null;
        }

        return (
            <span className='passp-timer'>
                {'00:'}
                {currentCountdown < 10 ? `0${currentCountdown}` : currentCountdown}
            </span>
        );
    }
}

Timer.propTypes = {
    onTimerEnd: PropTypes.func
};
