import './RestoreNeoPhonishButton.styl';
import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {Link} from '@components/Link';
import {ENTRY_RESTORE_NEOPHONISH_PROCESS} from '@blocks/UserEntryFlow/processes';
import metrika from '@blocks/metrics';

const b = cn('RestoreNeoPhonishButton');

class RestoreNeoPhonishButton extends React.PureComponent {
    onClick = () => {
        const {switchToModeRestoreLoginWithPhone, phone} = this.props;

        metrika.send('Клик по "Войти с помощью смс" для перехода в восстановление логина');
        switchToModeRestoreLoginWithPhone({phone, processName: ENTRY_RESTORE_NEOPHONISH_PROCESS});
    };

    render() {
        return (
            <div className={b()}>
                <Link onClick={this.onClick}>{i18n('_AUTH_.AuthSMS.btn')}</Link>
            </div>
        );
    }
}

RestoreNeoPhonishButton.propTypes = {
    switchToModeRestoreLoginWithPhone: PropTypes.func.isRequired,
    phone: PropTypes.string
};

export {RestoreNeoPhonishButton};
