import React, {Fragment, Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import {Field} from '@components/Field';
import {Button} from '@components/Button';
import sendPhoneCode from '@blocks/authv2/actions/restorePassword/sendPhoneCode';
import goToNextStep from '@blocks/authv2/actions/restorePassword/goToNextStep';
import UserLogin from '@blocks/authv2/components/RestorePassword/UserLogin/UserLogin';
import api from '@blocks/api';

class BindPhone extends Component {
    constructor(props) {
        super(props);

        this.state = {
            isCodeSend: false,
            number: ''
        };
        this.phoneField = React.createRef();
    }
    state = {
        isCodeSend: false,
        number: ''
    };

    componentDidMount() {
        const {confirmationType, commonTrackId} = this.props;

        this.phoneField.current.focus();

        if (confirmationType === 'confirmAndBindSecure' && !commonTrackId) {
            api.getTrackWithUid();
        }
    }

    handleSubmit = (event) => {
        const {number} = this.state;
        const {dispatch, confirmationType} = this.props;

        event.preventDefault();
        dispatch(sendPhoneCode(number, false, confirmationType));
    };

    handleChange = (value) => this.setState({number: value});

    toggleBindMethod = () => {
        this.props.dispatch(goToNextStep('bind-hint'));
    };

    render() {
        const {
            errorText,
            skipPageUrl,
            trackId,
            isForcePasswordChange,
            isNewMethodBindRequired,
            methodsToBind
        } = this.props;
        const {number} = this.state;

        return (
            <Fragment>
                <UserLogin />
                <form onSubmit={this.handleSubmit} action='/auth/restore/password/bind-phone'>
                    <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                    <Field
                        size='l'
                        ref={this.phoneField}
                        label={i18n('_AUTH_.Restore.phoneFieldLabel')}
                        value={number}
                        name='phone'
                        type='tel'
                        error={errorText}
                        onChange={this.handleChange}
                        view='big-input'
                    />
                    <div data-t='restore-bind-phone_sumbit' className='passp-button'>
                        <Button
                            onClick={this.handleSubmit}
                            type='submit'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            width='max'
                            size='l'
                        />
                    </div>
                    {!isForcePasswordChange && !isNewMethodBindRequired && (
                        <div data-t='restore-bind-phone-skip' className='passp-button'>
                            <Button
                                url={skipPageUrl}
                                type='link'
                                text={i18n('_AUTH_.reg_avatar.skip')}
                                view='pseudo'
                                width='max'
                                size='l'
                            />
                        </div>
                    )}
                    {isNewMethodBindRequired && methodsToBind.includes('hint') && (
                        <div data-t='restore-toggle-question' className='passp-button'>
                            <Button
                                type='button'
                                onClick={this.toggleBindMethod}
                                text={i18n('_AUTH_.no.phone')}
                                view='pseudo'
                                width='max'
                                size='l'
                            />
                        </div>
                    )}
                </form>
            </Fragment>
        );
    }
}

export default connect(mapStateToProps)(BindPhone);

BindPhone.propTypes = {
    errorText: PropTypes.string,
    skipPageUrl: PropTypes.string.isRequired,
    trackId: PropTypes.string,
    commonTrackId: PropTypes.string,
    dispatch: PropTypes.func.isRequired,
    confirmationType: PropTypes.string,
    isForcePasswordChange: PropTypes.bool,
    isNewMethodBindRequired: PropTypes.bool,
    methodsToBind: PropTypes.array.isRequired
};
