export default function mapStateToProps(state) {
    const {
        common: {retpath, profile_url: profileUrl, track_id: commonTrackId},
        restorePassword: {
            trackId,
            errors: {errorText},
            processState = {}
        }
    } = state;
    const {isForcePasswordChange, isNewMethodBindRequired, methodsToBind} = processState;
    const skipPageUrl = retpath || profileUrl;

    return {
        trackId,
        commonTrackId,
        errorText,
        skipPageUrl,
        isForcePasswordChange,
        isNewMethodBindRequired,
        methodsToBind
    };
}
