import React, {Fragment, Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';

import metrics from '../../../../metrics';
import {
    RESTORE_PASSWORD,
    RESTORE_PASSWORD_CAPTCHA_SHOW,
    RESTORE_PASSWORD_CAPTCHA_ENTERED
} from '../../../metrics_constants';

import CaptchaField from '../../CaptchaField/CaptchaField.jsx';
import {Button} from '@components/Button';
import mapStateToProps from './mapStateToProps';
import mapDispatchToProps from './mapDispatchToProps';
import checkCaptcha from '../../../actions/checkCaptcha';
import checkLogin from '../../../actions/restorePassword/checkLogin';
import goToNextStep from '../../../actions/restorePassword/goToNextStep';

class EnterCaptcha extends Component {
    componentDidMount() {
        const {
            trackId,
            isTrackShouldBeUpdated,
            captchaTrack,
            isCaptchaRequired,
            isCaptchaRepeatRequired,
            getStartData,
            changeCaptchaState,
            setCaptchaTrack,
            processError
        } = this.props;

        if (!trackId || isTrackShouldBeUpdated) {
            getStartData();
        }

        if (!isCaptchaRequired) {
            changeCaptchaState(true);
        }

        if (!captchaTrack) {
            setCaptchaTrack(trackId);
        }

        if (isCaptchaRepeatRequired) {
            processError('captcha.repeat_required');
        }

        metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_CAPTCHA_SHOW]);
    }

    handleSubmit = (event) => {
        const {dispatch, isCaptchaRepeatRequired} = this.props;
        const actionToCall = isCaptchaRepeatRequired
            ? checkCaptcha({action: goToNextStep, actionArguments: ['method']})
            : checkCaptcha({action: checkLogin});

        event.preventDefault();
        dispatch(actionToCall);
        metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_CAPTCHA_ENTERED]);
    };

    render() {
        const {trackId, errorText} = this.props;

        return (
            <Fragment>
                <form className='passp-normal_margin-form' onSubmit={this.handleSubmit}>
                    <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                    <CaptchaField isCaptchaRequired={true} forcedError={errorText} isShowCaptcha={true} />
                    <div data-t='restore-pwd_-captcha-sumbit' className='passp-button'>
                        <Button
                            onClick={this.handleSubmit}
                            type='submit'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                </form>
            </Fragment>
        );
    }
}

export default connect(mapStateToProps, mapDispatchToProps)(EnterCaptcha);

EnterCaptcha.propTypes = {
    trackId: PropTypes.string,
    captchaTrack: PropTypes.string,
    isCaptchaRequired: PropTypes.bool,
    isCaptchaRepeatRequired: PropTypes.bool,
    isTrackShouldBeUpdated: PropTypes.bool,
    errorText: PropTypes.string,
    dispatch: PropTypes.func.isRequired,
    getStartData: PropTypes.func.isRequired,
    changeCaptchaState: PropTypes.func.isRequired,
    setCaptchaTrack: PropTypes.func.isRequired,
    processError: PropTypes.func.isRequired
};
