import React, {Fragment, Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import {Field} from '@components/Field';
import {Button} from '@components/Button';
import {Checkbox} from '@components/Checkbox';
import sendEmail from '@blocks/authv2/actions/restorePassword/sendEmail';
import {
    RESTORE_PASSWORD,
    RESTORE_PASSWORD_EMAL_SHOW,
    RESTORE_PASSWORD_TOGGLE_SEND_CODE
} from '@blocks/authv2/metrics_constants';
import metrics from '@blocks/metrics';
import UserLogin from '@blocks/authv2/components/RestorePassword/UserLogin/UserLogin';

class EmailStart extends Component {
    state = {
        email: '',
        isSimple: false
    };

    ref = React.createRef();

    focus = () => {
        if (this.ref.current && this.ref.current.focus) {
            this.ref.current.focus();
        }
    };

    componentDidMount() {
        setTimeout(this.focus, 300);
        metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_EMAL_SHOW]);
    }

    handleSubmit = (event) => {
        const {email, isSimple} = this.state;
        const {dispatch} = this.props;

        event.preventDefault();
        dispatch(sendEmail(email, isSimple));
    };

    handleChange = (value) => {
        this.setState({
            email: value
        });
    };

    handleCheckbox = () => {
        this.setState((prevState) => ({
            isSimple: !prevState.isSimple
        }));
        metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_TOGGLE_SEND_CODE}: ${!this.state.isSimple}`]);
    };

    render() {
        const {errorText, trackId} = this.props;
        const {email} = this.state;

        return (
            <Fragment>
                <UserLogin />
                <form onSubmit={this.handleSubmit}>
                    <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                    <Field
                        size='l'
                        ref={this.ref}
                        label={i18n('_AUTH_.RestorePassword.email.label')}
                        value={email}
                        name='email'
                        type='text'
                        error={errorText}
                        onChange={this.handleChange}
                        view='big-input'
                    />

                    <Checkbox
                        label={i18n('_AUTH_.RestorePassword.email.checkbox')}
                        id='code_simple'
                        name='code_simple'
                        checked={this.state.isSimple}
                        onChange={this.handleCheckbox}
                        size='m'
                    />

                    <div data-t='restore-email_sumbit' className='passp-button'>
                        <Button
                            onClick={this.handleSubmit}
                            type='submit'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                </form>
            </Fragment>
        );
    }
}

export default connect(mapStateToProps)(EmailStart);

EmailStart.propTypes = {
    avatarUrl: PropTypes.string,
    login: PropTypes.string,
    errorText: PropTypes.string,
    trackId: PropTypes.string,
    dispatch: PropTypes.func.isRequired
};
