import React, {Fragment, Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import {Field} from '@components/Field';
import {Button} from '@components/Button';
import checkEmailCode from '../../../actions/restorePassword/checkEmailCode';
import metrics from '../../../../metrics';
import {RESTORE_PASSWORD, RESTORE_PASSWORD_EMAIL_CONFIRM_SHOW} from '../../../metrics_constants';
import Form from '@blocks/authv2/components/Form/Form.jsx';

class EmailConfirm extends Component {
    state = {
        code: ''
    };

    ref = React.createRef();

    focus = () => {
        if (this.ref.current && this.ref.current.focus) {
            this.ref.current.focus();
        }
    };

    componentDidMount() {
        setTimeout(this.focus, 300);
        metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_EMAIL_CONFIRM_SHOW]);
    }

    handleSubmit = (event) => {
        event.preventDefault();
        this.props.dispatch(checkEmailCode(this.state.code));
    };

    handleChange = (value) => {
        this.setState({
            code: value
        });
    };

    render() {
        const {errorText, trackId} = this.props;
        const {code} = this.state;

        return (
            <Fragment>
                <Form onSubmit={this.handleSubmit} action='/auth/restore/password/method-confirm'>
                    <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                    <Field
                        size='l'
                        ref={this.ref}
                        label={i18n('_AUTH_.email.enter-confirmation-code.label')}
                        value={code}
                        name='email-code'
                        type='text'
                        error={errorText}
                        onChange={this.handleChange}
                        view='big-input'
                    />
                    <div data-t='restore-email_sumbit' className='passp-button'>
                        <Button
                            onClick={this.handleSubmit}
                            type='submit'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                </Form>
            </Fragment>
        );
    }
}

export default connect(mapStateToProps)(EmailConfirm);

EmailConfirm.propTypes = {
    errorText: PropTypes.string,
    trackId: PropTypes.string,
    dispatch: PropTypes.func.isRequired
};
