import './FinishRestoration.styl';
import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import {Button} from '@components/Button';
import {Checkbox} from '@components/Checkbox';
import {Password} from '@components/Password';
import {PasswordConfirm} from '@components/PasswordConfirm';
import UserLogin from '../UserLogin/UserLogin.jsx';
import finishRestoration from '@blocks/authv2/actions/restorePassword/finishRestoration';
import processError from '@blocks/authv2/actions/restorePassword/processError';
import metrics from '@blocks/metrics';
import {RESTORE_PASSWORD, RESTORE_PASSWORD_FINISH_SHOW} from '../../../metrics_constants';
import {updateErrors} from '@blocks/actions/form';
import {getError} from '@blocks/utils';

class EnterPassword extends PureComponent {
    state = {
        isPerformLogout: false
    };

    componentDidMount() {
        metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_FINISH_SHOW]);
    }

    validateForm = (event) => {
        const {dispatch, hasPasswordError, password, passwordConfirm} = this.props;
        const hasPasswordConfirmError = passwordConfirm !== password;

        event.preventDefault();

        if (!password.trim()) {
            dispatch(processError('password.empty'));
            return;
        }

        if (hasPasswordConfirmError) {
            dispatch(updateErrors({field: 'password_confirm', error: getError('password_confirm', 'notequal')}));
        }

        if (hasPasswordError || hasPasswordConfirmError || password.length < 6) {
            return;
        }

        this.handleSubmit();
    };

    handleSubmit = () => {
        const {dispatch, isForcePasswordChange} = this.props;
        const {isPerformLogout} = this.state;

        dispatch(finishRestoration(isForcePasswordChange || isPerformLogout));
    };

    handleLogoutCheckbox = () => {
        this.setState((prevState) => ({
            isPerformLogout: !prevState.isPerformLogout
        }));
    };

    clearConfirmError = () => {
        this.props.dispatch(updateErrors({field: 'password_confirm', error: ''}));
    };

    render() {
        const {isPasswordOk, isCheckboxForRevokeShown, isForcePasswordChange, trackId} = this.props;

        return (
            <Fragment>
                <UserLogin />

                <form onSubmit={this.handleSubmit}>
                    <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                    <div className='passp-password-field'>
                        <Password
                            label={i18n('_AUTH_.field_password_createnew')}
                            shouldValidate={true}
                            validationTrack={trackId}
                            size='l'
                            isValid={isPasswordOk}
                            view='big-input'
                            onChange={this.clearConfirmError}
                        />
                        {isPasswordOk && (
                            <div className='EnterPassword-password-info EnterPassword-password-info_ok'>
                                {i18n('_AUTH_.password_valid')}
                            </div>
                        )}
                        <PasswordConfirm
                            shouldValidateOnUpdates={false}
                            label={i18n('_AUTH_.field_password_confirm')}
                            size='l'
                            view='big-input'
                        />
                        {isCheckboxForRevokeShown && (
                            <Checkbox
                                label={i18n('_AUTH_.restore.revoke_text_checkbox')}
                                id='logout_cbx'
                                name='logout_cbx'
                                checked={this.state.isPerformLogout || isForcePasswordChange}
                                disabled={isForcePasswordChange}
                                onChange={this.handleLogoutCheckbox}
                                size='m'
                            />
                        )}
                    </div>
                    <div data-t='restore-pwd_sumbit' className='passp-button'>
                        <Button
                            onClick={this.validateForm}
                            type='submit'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                </form>
            </Fragment>
        );
    }
}

export default connect(mapStateToProps)(EnterPassword);

EnterPassword.propTypes = {
    password: PropTypes.string,
    passwordConfirm: PropTypes.string,
    isPasswordWarningShowed: PropTypes.bool,
    hasPasswordError: PropTypes.bool,
    isPasswordOk: PropTypes.bool,
    isCheckboxForRevokeShown: PropTypes.bool,
    isForcePasswordChange: PropTypes.bool,
    trackId: PropTypes.string,
    dispatch: PropTypes.func.isRequired
};
