export default function mapStateToProps(state) {
    const {
        restorePassword: {trackId, processState = {}},
        form: {errors, values}
    } = state;
    const {
        isForcePasswordChange,
        isNewMethodBindRequired,
        methodsToBind,
        isCheckboxForRevokeShown,
        isRestorationDone
    } = processState;
    const {password: passwordErrors} = errors;

    return {
        trackId,
        password: values.password,
        passwordConfirm: values.password_confirm,
        isPasswordOk: !passwordErrors.code && !passwordErrors.warning && values.password.length >= 6,
        hasPasswordError: Boolean(passwordErrors.code) && !passwordErrors.warning,
        isCheckboxForRevokeShown,
        isForcePasswordChange,
        isNewMethodBindRequired,
        isRestorationDone,
        methodsToBind
    };
}
