import React, {Fragment, Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import {Field} from '@components/Field';
import {Button} from '@components/Button';

import validatePhone from '@blocks/authv2/actions/restorePassword/validatePhone';
import metrics from '@blocks/metrics';
import {RESTORE_PASSWORD, RESTORE_PASSWORD_PHONE_SHOW} from '@blocks/authv2/metrics_constants';
import UserLogin from '@blocks/authv2/components/RestorePassword/UserLogin/UserLogin';
import {Phone} from '@components/Phone';
import {FIELDS_NAMES} from '@components/Field/names';

class PhoneStart extends Component {
    state = {
        number: ''
    };

    ref = React.createRef();

    focus = () => {
        if (this.ref.current && this.ref.current.focus) {
            this.ref.current.focus();
        }
    };

    componentDidMount() {
        setTimeout(this.focus, 300);
        metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_PHONE_SHOW]);
    }

    handleSubmit = (event) => {
        const {number} = this.state;
        const {phone} = this.props;
        const {dispatch} = this.props;

        event.preventDefault();
        dispatch(validatePhone(number || phone));
    };

    handleChange = (value) => {
        this.setState({
            number: value
        });
    };

    render() {
        const {errorText, trackId, hasRoundViewExp} = this.props;
        const {number} = this.state;

        return (
            <Fragment>
                <UserLogin />
                <form onSubmit={this.handleSubmit} action='/auth/restore/password/method'>
                    <input type='hidden' name='track_id' value={trackId} readOnly={true} />

                    {hasRoundViewExp ? (
                        <Phone
                            name={FIELDS_NAMES.PHONE}
                            ref={this.ref}
                            hasPhoneMask={true}
                            view='rounded-corner'
                            size='l'
                        />
                    ) : (
                        <Field
                            size='l'
                            ref={this.ref}
                            label={i18n('_AUTH_.Restore.phoneFieldLabel')}
                            value={number}
                            name='phone'
                            type='tel'
                            error={errorText}
                            onChange={this.handleChange}
                            view='big-input'
                        />
                    )}

                    <div data-t='restore-phone_sumbit' className='passp-button'>
                        <Button
                            onClick={this.handleSubmit}
                            type='submit'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                </form>
            </Fragment>
        );
    }
}

export default connect(mapStateToProps)(PhoneStart);

PhoneStart.propTypes = {
    avatarUrl: PropTypes.string,
    login: PropTypes.string,
    errorText: PropTypes.string,
    trackId: PropTypes.string,
    phone: PropTypes.string,
    hasRoundViewExp: PropTypes.bool,
    dispatch: PropTypes.string
};
