import React, {Fragment, Component} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';
import mapStateToProps from './mapStateToProps';
import Timer from '../../RestoreLogin/Timer/Timer.jsx';
import Form from '@blocks/authv2/components/Form/Form.jsx';
import {Field} from '@components/Field';
import {Button} from '@components/Button';
import {CodeField} from '@components/CodeField';

import checkPhoneCode from '../../../actions/restorePassword/checkPhoneCode';
import validatePhone from '../../../actions/restorePassword/validatePhone';
import metrics from '../../../../metrics';
import {
    RESTORE_PASSWORD,
    RESTORE_PASSWORD_PHONE_CONFIRM_SHOW,
    RESTORE_PASSWORD_PHONE_CONFIRM_AGAIN
} from '../../../metrics_constants';

class PhoneConfirm extends Component {
    constructor(props) {
        super(props);

        this.state = {
            isRepeatActionBtnDisabled: true
        };
        this.codeField = React.createRef();
    }

    componentDidMount() {
        const {isPhoneValidForCall} = this.props;
        const metricsConfirmationType = isPhoneValidForCall ? 'звонок' : 'cмс';

        if (this.codeField.current) {
            this.codeField.current.focus();
        }

        metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_PHONE_CONFIRM_SHOW}: ${metricsConfirmationType}`]);
    }

    checkCodeLength = () => {
        const {phoneCode} = this.props;

        if (phoneCode.length === 6) {
            this.handleSubmit();
        }
    };

    updateRepeatBtnAction = () => {
        this.setState((prevState) => ({
            isRepeatActionBtnDisabled: !prevState.isRepeatActionBtnDisabled
        }));
    };

    handleSubmit = (event) => {
        const {isBindingNew, isForcePasswordChange, isNewMethodBindRequired, phoneCode, dispatch} = this.props;
        const isRestorationBind = isBindingNew && (isForcePasswordChange || isNewMethodBindRequired);

        if (event) {
            event.preventDefault();
        }

        dispatch(checkPhoneCode(phoneCode, isBindingNew, isRestorationBind));
    };

    sendConfirmationAgain = () => {
        const {dispatch, number, isPhoneValidForCall} = this.props;
        const metricsConfirmationType = isPhoneValidForCall ? 'звонок' : 'cмс';

        dispatch(validatePhone(number));
        this.setState((prevState) => ({
            isRepeatActionBtnDisabled: !prevState.isRepeatActionBtnDisabled
        }));
        metrics.send([RESTORE_PASSWORD, `${RESTORE_PASSWORD_PHONE_CONFIRM_AGAIN} ${metricsConfirmationType}`]);
    };

    render() {
        const {hasRoundViewExp, labelText, buttonText, trackId, isNotProduction} = this.props;
        const {isRepeatActionBtnDisabled} = this.state;

        return (
            <Fragment>
                <Form onSubmit={this.handleSubmit} action='/auth/restore/password/method-confirm'>
                    <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                    {hasRoundViewExp ? (
                        <CodeField codeLength={6} onKeyUp={this.checkCodeLength} />
                    ) : (
                        <Field
                            size='l'
                            ref={this.codeField}
                            tInfo={isNotProduction ? `sms_code_input_${trackId}` : undefined}
                            label={labelText}
                            name='phoneCode'
                            isPhoneCode={true}
                            type='tel'
                            view='big-input'
                        />
                    )}
                    <div data-t='restore-phone-code_sumbit' className='passp-button'>
                        <Button
                            onClick={this.handleSubmit}
                            type='submit'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                    <div data-t='restore-phone-code_repeat' className='passp-button passp-send-again-btn'>
                        {isRepeatActionBtnDisabled && <Timer onTimerEnd={this.updateRepeatBtnAction} />}
                        <Button
                            type='button'
                            text={buttonText}
                            view='pseudo'
                            size='l'
                            width='max'
                            disabled={isRepeatActionBtnDisabled}
                            onClick={this.sendConfirmationAgain}
                        />
                    </div>
                </Form>
            </Fragment>
        );
    }
}

export default connect(mapStateToProps)(PhoneConfirm);

PhoneConfirm.propTypes = {
    dispatch: PropTypes.func.isRequired,
    isPhoneValidForCall: PropTypes.bool,
    number: PropTypes.string,
    isBindingNew: PropTypes.bool,
    errorText: PropTypes.string,
    labelText: PropTypes.string,
    buttonText: PropTypes.string,
    trackId: PropTypes.string,
    isForcePasswordChange: PropTypes.bool,
    isNewMethodBindRequired: PropTypes.bool,
    isNotProduction: PropTypes.bool,
    hasRoundViewExp: PropTypes.bool,
    phoneCode: PropTypes.string
};
