import {hasExp} from '@blocks/selectors';

export default function mapStateToProps(state) {
    const {
        settings: {env = {}},
        restorePassword: {
            trackId,
            errors: {errorText},
            isPhoneValidForCall,
            number,
            processState = {}
        },
        common: {track_id},
        form: {values} = {}
    } = state;
    const labelText = isPhoneValidForCall
        ? i18n('_AUTH_.phone-confirm_call_code_label')
        : i18n('_AUTH_.phone-confirm_sms_code_label');
    const buttonText = isPhoneValidForCall
        ? i18n('_AUTH_.confirmation_call_repeat')
        : i18n('_AUTH_.code.send-again-link');
    const {isForcePasswordChange, isNewMethodBindRequired} = processState;

    return {
        phoneCode: values.phoneCode,
        trackId: trackId || track_id,
        errorText,
        labelText,
        buttonText,
        number,
        isPhoneValidForCall,
        isForcePasswordChange,
        isNewMethodBindRequired,
        isNotProduction: env.type === 'development' || env.type === 'testing',
        hasRoundViewExp: hasExp(state, 'rounded-input-exp')
    };
}
