import React, {Fragment, PureComponent} from 'react';
import PropTypes from 'prop-types';
import {connect} from 'react-redux';

import mapStateToProps from './mapStateToProps';
import checkAnswer from '@blocks/authv2/actions/restorePassword/checkAnswer';
import {updateCaptchaStatus} from '@blocks/authv2/actions/restorePassword';

import {Field} from '@components/Field';
import {Button} from '@components/Button';
import UserLogin from '@blocks/authv2/components/RestorePassword/UserLogin/UserLogin';
import metrics from '@blocks/metrics';
import {RESTORE_PASSWORD, RESTORE_PASSWORD_QUESTION_SHOW} from '@blocks/authv2/metrics_constants';

class QuestionStart extends PureComponent {
    state = {
        answer: ''
    };

    ref = React.createRef();

    focus = () => {
        if (this.ref.current && this.ref.current.focus) {
            this.ref.current.focus();
        }
    };

    componentDidMount() {
        const {isCaptchaRepeatRequired, dispatch} = this.props;

        if (isCaptchaRepeatRequired) {
            dispatch(updateCaptchaStatus(false));
        }

        setTimeout(this.focus, 300);
        metrics.send([RESTORE_PASSWORD, RESTORE_PASSWORD_QUESTION_SHOW]);
    }

    handleChange = (value) => {
        this.setState({
            answer: value
        });
    };

    handleSubmit = (event) => {
        event.preventDefault();
        this.props.dispatch(checkAnswer(this.state.answer));
    };

    render() {
        const {question, errorText, trackId, hasRoundViewExp} = this.props;

        return (
            <Fragment>
                <h2 className='passp-auth-form_subtitle'>{question}</h2>
                <UserLogin />
                <form onSubmit={this.handleSubmit} action='/auth/restore/password/method'>
                    <input type='hidden' name='track_id' value={trackId} readOnly={true} />
                    <Field
                        size='l'
                        ref={this.ref}
                        label={i18n('_AUTH_.field_hint_answer')}
                        value={this.state.answer}
                        name='answer'
                        type='text'
                        error={errorText}
                        onChange={this.handleChange}
                        hasErrorIcon={Boolean(hasRoundViewExp && errorText)}
                    />
                    <div data-t='restore-pwd_sumbit' className='passp-button'>
                        <Button
                            onClick={this.handleSubmit}
                            type='submit'
                            text={i18n('_AUTH_.next_registration_step')}
                            view='action'
                            size='l'
                            width='max'
                        />
                    </div>
                </form>
            </Fragment>
        );
    }
}

export default connect(mapStateToProps)(QuestionStart);

QuestionStart.propTypes = {
    question: PropTypes.string,
    errorText: PropTypes.string,
    trackId: PropTypes.string,
    isCaptchaRepeatRequired: PropTypes.bool,
    hasRoundViewExp: PropTypes.bool,
    dispatch: PropTypes.func.isRequired
};
