import {hasExp} from '@blocks/selectors';

export default function mapStateToProps(state) {
    const {
        restorePassword: {
            trackId,
            methodInfo,
            isCaptchaRepeatRequired,
            errors: {errorText}
        }
    } = state;

    return {
        trackId,
        isCaptchaRepeatRequired,
        question: methodInfo.question || '',
        errorText,
        hasRoundViewExp: hasExp(state, 'rounded-input-exp')
    };
}
