import React from 'react';
import PropTypes from 'prop-types';

export default function LoginsSuggest({logins, onChange, selected}) {
    return (
        <ul className='passp-suggest-list'>
            {logins.map((login, index) => {
                return (
                    <li onClick={onChange} key={login}>
                        <input
                            type='radio'
                            id={`login${index}`}
                            value={login}
                            defaultChecked={selected === login ? 'checked' : undefined}
                            name='login-suggest'
                        />
                        <label htmlFor={`login${index}`}>{login}</label>
                    </li>
                );
            })}
        </ul>
    );
}

LoginsSuggest.propTypes = {
    logins: PropTypes.array,
    onChange: PropTypes.func.isRequired,
    selected: PropTypes.string
};
