export default function mapStateToProps(state) {
    const {
        restorePassword: {trackId, logins, errors = {}},
        auth: {form = {}, unitedAccounts},
        common: {addUserUrl, restoreLoginUrl}
    } = state;
    const {login = ''} = form;
    const {errorText} = errors;
    const fieldLink = {
        pseudo: true,
        url: restoreLoginUrl,
        text: i18n('_AUTH_.restore_id_link')
    };
    const isAuthDataAvailable = unitedAccounts !== undefined;

    return {
        trackId,
        login,
        logins,
        errorText,
        addUserUrl,
        fieldLink,
        isAuthDataAvailable
    };
}
