import './UserLogin.styl';
import React, {PureComponent} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {connect} from 'react-redux';
import {AccountsListItem} from '@components/AccountsListItem/AccountsListItem.jsx';
import mapStateToProps from './mapStateToProps';

const b = cn('UserLogin');

class UserLogin extends PureComponent {
    render() {
        const {account} = this.props;

        return (
            <div className={b()}>
                <AccountsListItem account={account} isStatic={true} />
            </div>
        );
    }
}

export default connect(mapStateToProps)(UserLogin);

UserLogin.propTypes = {
    account: PropTypes.shape({
        login: PropTypes.string.isRequired,
        avatar_url: PropTypes.string.isRequired
    })
};
