import './SamlSsoButton.styl';
import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {redirectToSAML} from '../../actions/redirectToSAML';
import {Button} from '@components/Button';

const b = cn('AuthSamlSsoButton');

export class SamlSsoButton extends Component {
    constructor(props) {
        super(props);

        this.authSamlSso = this.authSamlSso.bind(this);
    }

    authSamlSso() {
        const {dispatch, samlSsoUrl} = this.props;

        dispatch(
            redirectToSAML({
                samlSsoUrl
            })
        );
    }

    render() {
        return (
            <div className={b()}>
                <Button
                    onClick={this.authSamlSso}
                    type='button'
                    view='pseudo'
                    size='l'
                    width='max'
                    dataT='social:auth:sso'
                >
                    {i18n('_AUTH_.social_sign_in').replace('%1', 'SAML SSO')}
                </Button>
            </div>
        );
    }
}

SamlSsoButton.propTypes = {
    lang: PropTypes.string.isRequired,
    samlSsoUrl: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired
};
