import {connect} from 'react-redux';
import {SamlSsoButton} from './SamlSsoButton.jsx';

const mapStateToProps = (state = {}) => {
    const {
        settings: {language},
        auth: {processedAccount: account}
    } = state;

    const samlSsoUrl = (account || {}).samlSsoUrl;

    return {
        samlSsoUrl,
        lang: language
    };
};

const ConnectedSamlSsoButton = connect(mapStateToProps)(SamlSsoButton);

export {ConnectedSamlSsoButton as SamlSsoButton};
