import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import {Button} from '@components/Button';

export const SignInButton = ({isDisabled, view}) => {
    const elemId = 'passp:sign-in';

    return (
        <div className={classnames('passp-button passp-sign-in-button')}>
            <Button
                type='submit'
                dataT={elemId}
                id={elemId}
                text={i18n('_AUTH_.sign_in')}
                view={view}
                disabled={isDisabled}
                width='max'
                size='l'
            />
        </div>
    );
};

SignInButton.defaultProps = {
    isDisabled: false,
    view: 'action'
};

SignInButton.propTypes = {
    isDisabled: PropTypes.bool,
    view: PropTypes.string
};
