import {connect} from 'react-redux';
import {SocialBlock} from './SocialBlock.jsx';
import {getLanguage, isBookQREnabled} from '@blocks/selectors';
import startSocialAuth from '@blocks/authv2/actions/startSocialAuth';
import switchToModeMagic from '@blocks/authv2/actions/switchToModeMagic';

const mapStateToProps = (state = {}, {isRegister}) => {
    const {
        social = {},
        customs: {socialScope, minimal, hideQrButton = false, socialButtonsWithText = false, autoRuButton},
        settings: {intranet, env, dir},
        auth: {mode},
        am = {}
    } = state;
    const socialProvidersPositions = {
        autoRu: 0,
        apl: 10,
        vk: 20,
        fb: 30,
        gg: 35,
        qr: 40,
        esia: 45,
        mr: 50,
        ok: 60,
        tw: 70
    };
    const providers = {primary: [], secondary: []}; // AUTH V5

    let socialProviders = social.providers.slice();

    if (!isRegister && !am.isAm && !hideQrButton && !isBookQREnabled(state)) {
        socialProviders.push({
            id: 'qr',
            enabled: true,
            data: {
                code: 'qr',
                display_name: {default: i18n('_AUTH_.qr-code')}
            }
        });
    }

    if (!isRegister && autoRuButton && autoRuButton.link) {
        socialProviders.push({
            id: 'autoRu',
            enabled: true,
            data: {
                code: 'autoRu',
                display_name: {default: i18n('ProfileSubs.autoru')},
                link: autoRuButton.link
            }
        });
    }

    socialProviders = socialProviders
        .slice()
        .filter((i) => i.enabled)
        .sort(function(p1, p2) {
            return socialProvidersPositions[p1.data.code] > socialProvidersPositions[p2.data.code] ? 1 : -1;
        });

    // если больше 5 провайдеров, то выводим первые пять, остальные прячем в попап
    if (socialProviders.length > 5) {
        providers.primary = socialProviders.slice(0, 4);
        providers.secondary = socialProviders.slice(4);
    } else {
        // если 5 и меньше, то выводим все
        providers.primary = socialProviders;
    }

    return {
        socialButtonsWithText,
        socialScope,
        minimal,
        intranet,
        isAm: am.isAm,
        mode,
        providers,
        language: getLanguage(state),
        env: env.type,
        dir
    };
};

const mapDispatchToProps = {
    startSocialAuth,
    switchToModeMagic
};

const ConnectedSocialBlock = connect(mapStateToProps, mapDispatchToProps)(SocialBlock);

export {ConnectedSocialBlock as SocialBlock};
