import './SocialButton.styl';
import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import startSocialAuth from '../../actions/startSocialAuth';
import {SHOW_SOCIAL_FORM} from '../../metrics_constants';
import metrics from '../../../metrics';
import {Button} from '@components/Button';
import {Icon} from '@components/Icon';

const b = cn('AuthSocialButton');

export class SocialButton extends Component {
    constructor(props) {
        super(props);

        this.authSocial = this.authSocial.bind(this);
    }

    componentDidMount() {
        const {isShowPasswordField} = this.props;

        if (!isShowPasswordField) {
            metrics.send([SHOW_SOCIAL_FORM]);
        }
    }

    authSocial() {
        const {socialScope, provider, dispatch} = this.props;
        const {
            data: {code}
        } = provider;

        dispatch(
            startSocialAuth({
                provider: code,
                scope: socialScope && socialScope[code]
            })
        );
    }

    render() {
        const {provider, lang} = this.props;

        if (!provider) {
            return null;
        }

        const {data = {}} = provider;
        const {display_name: displayName = {}, code} = data;
        const name = displayName[lang] || displayName.default;

        return (
            <div className={b()}>
                <Button
                    onClick={this.authSocial}
                    type='button'
                    view='pseudo'
                    size='l'
                    width='max'
                    dataT={`social:auth:${code}`}
                >
                    <Icon type={code} size='s' place='button' />
                    {i18n('_AUTH_.social_sign_in').replace('%1', name)}
                </Button>
            </div>
        );
    }
}

SocialButton.propTypes = {
    provider: PropTypes.object,
    lang: PropTypes.string.isRequired,
    isShowPasswordField: PropTypes.bool,
    dispatch: PropTypes.func.isRequired,
    socialScope: PropTypes.object
};
