import {connect} from 'react-redux';
import {SocialButton} from './SocialButton.jsx';

const mapStateToProps = (state = {}) => {
    const {
        settings: {language},
        auth: {processedAccount: account},
        social: {providers}
    } = state;

    let authMethod = (account || {}).preferred_auth_method;

    if (authMethod === 'magic_x_token' || authMethod.indexOf('social_') < 0) {
        authMethod = account.allowed_auth_methods.filter((method) => method.indexOf('social_') > -1)[0];
    }

    const provider = providers.filter(({data}) => `social_${data.code}` === authMethod)[0] || null;

    return {
        provider,
        lang: language
    };
};

const ConnectedSocialButton = connect(mapStateToProps)(SocialButton);

export {ConnectedSocialButton as SocialButton};
