import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

const b = cn('passp-title');

const Title = ({cls = '', children, dataT}) => {
    return (
        <h1 data-t={dataT ? `title:${dataT}` : 'title'} className={`${b()} ${cls ? cls : ''}`}>
            {children}
        </h1>
    );
};

Title.defaultProps = {
    isPopupTitle: false
};

Title.propTypes = {
    cls: PropTypes.string,
    dataT: PropTypes.string,
    children: PropTypes.node.isRequired
};

export default Title;
